#pragma once

#include <crypta/lib/native/database/reply_handler.h>
#include <crypta/lib/native/log/log.h>

#include <library/cpp/string_utils/base64/base64.h>

#include <util/generic/maybe.h>

namespace NCrypta {
    class TSynchronousClient : public TMoveOnly {
    public:
        using TValueEncoder = std::function<TString(const TStringBuf)>;

        explicit TSynchronousClient(TValueEncoder valueEncoder = IdentityEncoder, const TString &logName = "main");
        explicit TSynchronousClient(IDatabasePtr database, IReplyHandlerPtr replyHandler, TValueEncoder valueEncoder = IdentityEncoder, const TString &logName = "main");
        TSynchronousClient(TSynchronousClient&&) = default;

        void SetDatabase(IDatabasePtr database);
        void SetReplyHandler(IReplyHandlerPtr replyHandler);

        TMaybe<NCrypta::TRecord> Get(const TString &key);
        void Set(const TString &key, const TString &value, TDuration ttl = TDuration(), ui64 cas = NCrypta::TRecord::NO_CAS);
        void Remove(const TString &key, ui64 cas = NCrypta::TRecord::NO_CAS);

        static const TValueEncoder IdentityEncoder;

    protected:
        IDatabasePtr Database;
        IReplyHandlerPtr ReplyHandler;

    private:
        using TDbRequestId = IDatabase::TRequestId;

        void ResetRequest();
        void ProcessRequest(TDbRequestId id);
        void LogUnexpectedRequestId(TDbRequestId id);

        TDbRequestId RequestId;
        bool IsRequestReplied;
        TMaybe<TRecord> Result;
        NLog::TLogPtr Log;
        TValueEncoder ValueEncoder;
    };
}
