#include <crypta/lib/native/dates/dates.h>
#include <util/datetime/base.h>


namespace NDates {
    bool HasActiveDate(const NYT::TNode::TListType& dates, time_t oldestActiveTimestamp, bool withOneDayFilter);
    bool HasActiveDate(const NYT::TNode& dates, time_t oldestActiveTimestamp, bool withOneDayFilter);
}

bool NDates::HasActiveDate(const NYT::TNode::TListType& dates, time_t oldestActiveTimestamp, bool withOneDayFilter) {
    if (withOneDayFilter && dates.size() < 2) {
        return false;
    }
    for (const auto& date : dates) {
        time_t timestamp;
        ParseISO8601DateTime(date.AsString().data(), timestamp);
        if (oldestActiveTimestamp < timestamp) {
            return true;
        }
    }
    return false;
}

bool NDates::HasActiveDate(const NYT::TNode& dates, time_t oldestActiveTimestamp, bool withOneDayFilter) {
    if (dates.IsList()) {
        return HasActiveDate(dates.AsList(), oldestActiveTimestamp, withOneDayFilter);
    }
    else if (!dates.IsNull()) {
        ythrow yexception() << "Unknown dates type " << dates.GetType();
    }
    return false;
}

bool NDates::HasActiveDate(const NYT::TNode& row, const TString& dateField, time_t oldestActiveTimestamp, bool withOneDayFilter) {
    if (row.HasKey(dateField)) {
        return HasActiveDate(row[dateField], oldestActiveTimestamp, withOneDayFilter);
    }
    return false;
}
