#include <crypta/lib/native/dns/fqdn_mask.h>

#include <library/cpp/testing/benchmark/bench.h>

#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/generic/xrange.h>

using namespace NCrypta;

const char* ONE_NUMBER_HOSTNAME = "myt1-18250.vm.search.yandex.net";
const char* TWO_NUMBERS_HOSTNAME = "myt1-02-18250.vm.search.yandex.net";
const char* FOUR_NUMBERS_HOSTNAME = "vla2-8538-c31-vla-yabs-frontend-448-8496.gencfg-c.yandex.net";
const char* ONE_NUMBER_IN_WORD_HOSTNAME = "zfront-i11.kaizen.yandex.net";
const char* NON_FOLDABLE_HOSTNAME = "zfront-s7.kaizen.yandex.net";

const TVector<TString> HOSTNAMES = {
    ONE_NUMBER_HOSTNAME,
    TWO_NUMBERS_HOSTNAME,
    FOUR_NUMBERS_HOSTNAME,
    ONE_NUMBER_IN_WORD_HOSTNAME,
    NON_FOLDABLE_HOSTNAME
};

#define SINGLE_HOSTNAME_BENCHMARK(benchmark_name, host_name) \
    Y_CPU_BENCHMARK(benchmark_name, iface) {                 \
        TString host = host_name;                            \
                                                             \
        for (const auto i : xrange(iface.Iterations())) {    \
            Y_UNUSED(i);                                     \
                                                             \
            auto copy = host;                                \
            MaskHostNumbers(copy);                           \
        }                                                    \
    }

SINGLE_HOSTNAME_BENCHMARK(OneNumberHostname, ONE_NUMBER_HOSTNAME)
SINGLE_HOSTNAME_BENCHMARK(TwoNumbersHostname, TWO_NUMBERS_HOSTNAME)
SINGLE_HOSTNAME_BENCHMARK(FourNumbersHostname, FOUR_NUMBERS_HOSTNAME)
SINGLE_HOSTNAME_BENCHMARK(OneNumberInWordHostname, ONE_NUMBER_IN_WORD_HOSTNAME)
SINGLE_HOSTNAME_BENCHMARK(NonFoldableHostname, NON_FOLDABLE_HOSTNAME)

Y_CPU_BENCHMARK(AllHostnames, iface) {
    for (const auto i : xrange(iface.Iterations())) {
        Y_UNUSED(i);

        for (const auto& host : HOSTNAMES) {
            TString copy = host;
            MaskHostNumbers(copy);
        }
    }
}
