#pragma once

#include "addr_hash.h"
#include "types.h"

#include <library/cpp/threading/chunk_queue/queue.h>
#include <library/cpp/threading/light_rw_lock/lightrwlock.h>
#include <util/datetime/base.h>
#include <util/generic/hash.h>
#include <util/generic/maybe.h>
#include <util/network/address.h>
#include <util/system/thread.h>
#include <util/thread/factory.h>

namespace NCrypta {
    class TCachingReverseDnsResolver {
    public:
        using TAddr = NAddr::TOpaqueAddr;

        explicit TCachingReverseDnsResolver();
        ~TCachingReverseDnsResolver();

        // Thread-safe, can be called from different threads.
        TMaybe<TString> Resolve(const TAddr& addr) const;

    private:
        void ResolverRoutine();

        using TRequestsQueue = NThreading::TManyOneQueue<TAddr>;
        using TCache = THashMap<TAddr, TString, TAddrOnlyHash, TAddrOnlyEqual>;

        mutable TRequestsQueue RequestsQueue;
        TLightRWLock CacheLock;
        TCache Cache;
        std::atomic_bool IsThreadRunning;
        TAutoPtr<IThreadFactory::IThread> ResolverThread;
    };
}
