#include <contrib/libs/re2/re2/re2.h>
#include <library/cpp/regex/pcre/regexp.h>

#include <util/generic/string.h>
#include <util/string/subst.h>

#include <algorithm>
#include <cctype>
#include <regex>


namespace NCrypta {
    static const  re2::RE2 HEXADECIMAL_GROUP(R"(-[a-f0-9]{2,}\b)");
    static const re2::RE2 TWO_OR_MORE_DIGITS_REGEX(R"(\d{2,})");

    TString MaskHostNumbers(const TString& host) {
        auto ret = host;
        re2::RE2::GlobalReplace(&ret, HEXADECIMAL_GROUP, "-X");
        re2::RE2::GlobalReplace(&ret, TWO_OR_MORE_DIGITS_REGEX, "X");
        return ret;
    }
}
