#include <netdb.h>

#include "reverse_dns_resolver.h"

namespace NCrypta {
    TReverseDnsResolver::TResult TReverseDnsResolver::Resolve(const NDns::TAddr& addr) {
        char hbuf[NI_MAXHOST];
        auto status = ::getnameinfo(addr.Addr(), addr.Len(), hbuf, sizeof(hbuf), 0, 0, NI_NAMEREQD);

        if (status == 0) {
            return TResult{TString(hbuf), NDns::EReverseRequestOutcome::Ok};
        } else if (status == EAI_AGAIN) {
            return TResult{TString(), NDns::EReverseRequestOutcome::EAgain};
        } else {
            return TResult{TString(), NDns::EReverseRequestOutcome::EOther};
        }
    }
}
