#include <crypta/lib/native/dns/fqdn_mask.h>

#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/vector.h>

#include <tuple>
#include <utility>

Y_UNIT_TEST_SUITE(FqdnMask) {
    using namespace NCrypta;

    Y_UNIT_TEST(MaskHostNumbers) {
        TVector<std::tuple<TString, TString>> cases = {
            std::make_tuple("awaps-as01e.yandex.ru", "awaps-asXe.yandex.ru"),
            std::make_tuple("awaps-as01i.yandex.ru", "awaps-asXi.yandex.ru"),
            std::make_tuple("man1-02-4e1-man-bigb-eagle-2-afd.gencfg-c.yandex.net", "man1-X-X-man-bigb-eagle-2-X.gencfg-c.yandex.net"),
            std::make_tuple("man1-02-man-bigb-eagle-2-11e.gencfg-c.yandex.net", "man1-X-man-bigb-eagle-2-X.gencfg-c.yandex.net"),
            std::make_tuple("free-21880-a1a-sas-portal-morda-17154.gencfg-c.yandex.net", "free-X-X-sas-portal-morda-X.gencfg-c.yandex.net"),
            std::make_tuple("iva1-1580-3f8-msk-iva-yabs-fro-63f-17768.gencfg-c.yandex.net", "iva1-X-X-msk-iva-yabs-fro-X-X.gencfg-c.yandex.net"),
            std::make_tuple("iva2-904030bc49de.qloud-c.yandex.net", "iva2-X.qloud-c.yandex.net"),
            std::make_tuple("iva-b-lb15a.yndx.net", "iva-b-lbXa.yndx.net"),
            std::make_tuple("localhost", "localhost"),
            std::make_tuple("myt1-0175-msk-myt-yabs-frontend-s-aa7-23649.gencfg-c.yandex.net", "myt1-X-msk-myt-yabs-frontend-s-X-X.gencfg-c.yandex.net"),
            std::make_tuple("myt1-6197-msk-myt-yabs-frontend-s-32d-17929.gencfg-c.yandex.net", "myt1-X-msk-myt-yabs-frontend-s-X-X.gencfg-c.yandex.net"),
            std::make_tuple("myt1-678314382f9b.qloud-c.yandex.net", "myt1-X.qloud-c.yandex.net"),
            std::make_tuple("sas1-0223-sas-bigb-resharder-stable-8770.gencfg-c.yandex.net", "sas1-X-sas-bigb-resharder-stable-X.gencfg-c.yandex.net"),
            std::make_tuple("sas1-2228-215-sas-bigb-resharde-849-8770.gencfg-c.yandex.net", "sas1-X-X-sas-bigb-resharde-X-X.gencfg-c.yandex.net"),
            std::make_tuple("sas2-1065-sas-yabs-frontend-serve-4da-17032.gencfg-c.yandex.net", "sas2-X-sas-yabs-frontend-serve-X-X.gencfg-c.yandex.net"),
            std::make_tuple("slovo100-sas-bigb-resharder-stable-8770.gencfg-c.yandex.net", "slovoX-sas-bigb-resharder-stable-X.gencfg-c.yandex.net"),
            std::make_tuple("zfront-i11.kaizen.yandex.net", "zfront-iX.kaizen.yandex.net"),
            std::make_tuple("zfront-i2.kaizen.yandex.net", "zfront-i2.kaizen.yandex.net"),

            std::make_tuple("myt1-02-18250_vm_search_yandex_net", "myt1-X-X_vm_search_yandex_net"),
            std::make_tuple("host99999", "hostX"),
            std::make_tuple("bsst1-01e.yandex.ru", "bsst1-X.yandex.ru"),
            std::make_tuple("bsyeti99i.yandex.ru", "bsyetiXi.yandex.ru"),

            std::make_tuple("host9.com", "host9.com"),
            std::make_tuple("host.com", "host.com"),
            std::make_tuple("host", "host"),
            std::make_tuple("host99.com", "hostX.com"),
            std::make_tuple("host99999", "hostX"),
            std::make_tuple("host99999.com", "hostX.com"),
            std::make_tuple("host99999e", "hostXe"),
            std::make_tuple("host99999e.com", "hostXe.com"),
            std::make_tuple("host99999zz", "hostXzz"),
            std::make_tuple("host99999zz.com", "hostXzz.com"),
            std::make_tuple("host99999zzzzzzzzzzzzzzzz", "hostXzzzzzzzzzzzzzzzz"),
            std::make_tuple("host99999zzzzzzzzzzzzzzzz.com", "hostXzzzzzzzzzzzzzzzz.com"),

            std::make_tuple("host9z9.com", "host9z9.com"),
            std::make_tuple("host9z9-1.com", "host9z9-1.com"),
            std::make_tuple("host9z9-1e.com", "host9z9-X.com"),
            std::make_tuple("host9z9-11et.com", "host9z9-Xet.com"),
            std::make_tuple("d3.d2.tld", "d3.d2.tld"),
            std::make_tuple("abc.def.ghi", "abc.def.ghi"),
            std::make_tuple("abc0.def0.ghi", "abc0.def0.ghi"),
            std::make_tuple("abc9.def9.ghi", "abc9.def9.ghi"),
            std::make_tuple("abc0123456789.def0.ghi", "abcX.def0.ghi"),
            std::make_tuple("abc-99.def.com", "abc-X.def.com"),
            std::make_tuple("abc-9-9-9-9-9.com", "abc-9-9-9-9-9.com"),
            std::make_tuple("abc-9t-9e-9hh-9hhh-9999hhhh-a9z.com", "abc-9t-X-9hh-9hhh-Xhhhh-a9z.com"),

            std::make_tuple("", ""),
            std::make_tuple("%$!@#$%^&*()_.-9", "%$!@#$%^&*()_.-9"),

            std::make_tuple("a:", "a:"),
            std::make_tuple("Aaaaa9.com", "Aaaaa9.com")
        };

        for (const auto& _case: cases) {
            const auto& originalHost = std::get<0>(_case);
            const auto& refMaskedNumbersOnly = std::get<1>(_case);
            UNIT_ASSERT_STRINGS_EQUAL(refMaskedNumbersOnly, MaskHostNumbers(originalHost));
        }
    }
}
