#pragma once

#include "processor_factory.h"

#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/pqlib/cookie_queue.h>
#include <crypta/lib/native/stats/stats.h>

#include <yt/yt/core/misc/ref_counted.h>

namespace NCrypta::NEventProcessing {
    class TWorker : public NYT::TRefCounted {
    public:
        TWorker(
            const IProcessorFactory& processorFactory,
            NPQ::TCookieQueue& cookiesToCommit,
            TStats& stats,
            TDuration retryTimeout = TDuration::MilliSeconds(100)
        );

        ~TWorker() = default;

        void Process(NPQ::TConsumer::TReadResult&& readResult);

    private:
        bool ProcessEvent(const TStringBuf& event);

        const IProcessorFactory& ProcessorFactory;
        NPQ::TCookieQueue& CookiesToCommit;
        TStats& Stats;
        TDuration RetryTimeout;
        NLog::TLogPtr Log;
    };
}
