#pragma once

#include "fetchers.h"

#include <ads/bsyeti/libs/experiments/builder.h>
#include <ads/bsyeti/libs/experiments/plugins/bigb/plugin.h>
#include <ads/bsyeti/libs/experiments/plugins/eagle/plugin.h>
#include <crypta/lib/native/time/shifted_clock.h>
#include <crypta/lib/proto/config/exp_system.pb.h>
#include <util/datetime/base.h>
#include <util/system/rwlock.h>

namespace NCrypta::NExpSystem {
    class TExperimentSystemManager {
    public:
        using TExpSystemPtr = TAtomicSharedPtr<NBSYeti::TExperimentSystem>;

        TExperimentSystemManager(const TExperimentSystemOptions& options = TExperimentSystemOptions{});
        TExperimentSystemManager(const TExperimentSystemOptions& options, TAtomicSharedPtr<IFetcher> fetcher);

        TExpSystemPtr GetExperimentSystem() const;
        NBSYeti::NExperimentParameters::TBigbPlugin GetBigbParameters(NExperiments::TUniqId id) const;
        NBSYeti::NExperimentParameters::TBigbPlugin GetBigbParameters(const NExperiments::TUserIds& id) const;
        NBSYeti::NExperimentParameters::TEaglePlugin GetEagleParameters(NExperiments::TUniqId id) const;
        NBSYeti::NExperimentParameters::TEaglePlugin GetEagleParameters(const NExperiments::TUserIds& id) const;
        bool Update();

    private:
        TRWMutex ExperimentSystemLock;
        TExperimentSystemOptions Options;
        TAtomicSharedPtr<IFetcher> FetcherPtr;
        TExpSystemPtr ExperimentSystemPtr;

        TExpSystemPtr FetchExperimentSystem() const;
        template <typename T>
        T GetParameters(NExperiments::TUserIds id) const {
            auto params = GetExperimentSystem()->GetParameters(
                id,
                TShiftedClock::Now().TimeT());
            return std::move(*params.MutableAs<T>());
        }
    };
}
