#include "fetchers.h"

#include <util/string/builder.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/neh/neh.h>

namespace NCrypta::NExpSystem {
    void TSandboxFetcher::Fetch(const TString& url, TString& dest) const {
        NNeh::TResponseRef resp = NNeh::Request(url)->Wait(Timeout);

        Y_ENSURE(resp, "Timeout fetching " << url);
        Y_ENSURE(!resp->IsError(), resp->GetErrorText());

        dest = std::move(resp->Data);
    }

    TString TSandboxFetcher::GetResourceUrl(const TString& desc, const TString& fileName) const {
        NJson::TJsonValue jsonDesc;
        NJson::ReadJsonTree(TStringBuf(desc), &jsonDesc);

        return TStringBuilder() << jsonDesc["items"][0]["http"]["proxy"].GetStringSafe()
                                << fileName;
    }

    TString TSandboxFetcher::GetDescUrl(const TString& url, const TString& type) const {
        return TStringBuilder() << url
                                << "?limit=1&state=READY&order=-time.created&type="
                                << type;
    }

    TString TSandboxFetcher::FetchLastResourceFromSandbox(const TString& url, const TString& type, const TString& fileName) const {
        TString tmp;

        Fetch(GetDescUrl(url, type), tmp);
        Fetch(GetResourceUrl(tmp, fileName), tmp);

        return tmp;
    }

    TString TSandboxFetcher::FetchExpSystem() const {
        const TString ExpSystemResourceType{"BS_YETI_LIGHT_CONFIGS"};
        return FetchLastResourceFromSandbox(Url, ExpSystemResourceType, "/select_type_active.json");
    }

    TString TSandboxFetcher::FetchAbSystem() const {
        const TString AbSystemResourceType{"BIGB_AB_EXPERIMENTS_PRODUCTION_CONFIG"};
        return FetchLastResourceFromSandbox(Url, AbSystemResourceType);
    }
}
