#pragma once

#include <util/datetime/base.h>

namespace NCrypta::NExpSystem {
    class IFetcher {
    public:
        virtual TString FetchExpSystem() const = 0;
        virtual TString FetchAbSystem() const = 0;

        virtual ~IFetcher(){};
    };

    class TSandboxFetcher: public IFetcher {
    public:
        TSandboxFetcher(TString url)
            : Url(std::move(url))
        {
        }

        static constexpr TDuration Timeout = TDuration::Seconds(10);
        const TString Url;

        virtual TString FetchExpSystem() const override;
        virtual TString FetchAbSystem() const override;

    private:
        void Fetch(const TString& url, TString& dest) const;
        TString GetResourceUrl(const TString& desc, const TString& fileName) const;
        TString GetDescUrl(const TString& url, const TString& type) const;
        TString FetchLastResourceFromSandbox(const TString& url, const TString& type, const TString& filename = {}) const;
    };

    class TTestFetcher: public IFetcher {
    public:
        virtual TString FetchExpSystem() const override {
            return ExpData;
        };
        virtual TString FetchAbSystem() const override {
            return AbData;
        };

        void SetExpData(TString expData) {
            ExpData = std::move(expData);
        }
        void SetAbData(TString abData) {
            AbData = std::move(abData);
        }

    private:
        TString ExpData{"[]"};
        TString AbData{"[]"};
    };
}
