#pragma once

#include <util/generic/hash.h>
#include <util/generic/string.h>
#include <util/string/join.h>

namespace NCrypta {
    using TFeaturesMapping = THashMap<TString, size_t>;

    class TFeaturesCalculator {
    public:
        TFeaturesCalculator() = default;

        TFeaturesCalculator(TFeaturesMapping featuresMapping);

        template <typename T>
        bool AddFeatureToVector(TVector<T>& featuresVector, const TString& featureName, const T& value = 1) const {
            const auto featuresIter = FeaturesMapping.find(featureName);
            const bool featureFound = featuresIter != FeaturesMapping.end();
            if (featureFound) {
                featuresVector[featuresIter->second] += value;
            }
            return featureFound;
        }

        size_t GetSize() const {
            return FeaturesMapping.size();
        }

        template <typename TFeatureType, typename TValue>
        static TString GetFeatureName(const TFeatureType& featureType, const TValue& value) {
            return Join("_", featureType, value);
        }

        TFeaturesMapping FeaturesMapping;
    };
}
