#include "fingerprint.h"

#include <contrib/libs/highwayhash/highwayhash/sip_hash.h>

#include <util/digest/city.h>
#include <util/draft/ip.h>
#include <util/generic/variant.h>
#include <util/string/builder.h>
#include <util/string/cast.h>


namespace {
    struct TSerializeIpVisitor {
        TString operator()(const TIp4& ip) const {
            return TString(reinterpret_cast<const char*>(&ip), 4);
        }
        TString operator()(const TIp6& ip) const {
            return TString(reinterpret_cast<const char*>(&ip.Data), 16);
        }
    };
}

TString NCrypta::NFingerprint::CalculateFingerprint(const TStringBuf& url, const TIp4Or6& ip, const TStringBuf& userAgent) {
    const auto sipHashData = std::visit(TSerializeIpVisitor(), ip) + userAgent;
    return TStringBuilder() << CityHash64(url) << ":"
                            << highwayhash::SipHash({0, 0}, sipHashData.Data(), sipHashData.Size());
}