#pragma once

#include <util/generic/string.h>
#include <util/string/cast.h>
#include <util/string/builder.h>
#include <util/string/subst.h>

namespace NCrypta {
    template <typename T>
    TString CanonizeGraphiteMetricNode(const T& node) {
        TString result(ToString(node));
        SubstGlobal(result, '.', '_');
        return result;
    };

    void AppendGraphiteMetricNodes(TStringBuilder& builder);

    template <typename T, typename... Args>
    void AppendGraphiteMetricNodes(TStringBuilder& builder, const T& next, const Args&... args) {
        builder << "." << next;
        AppendGraphiteMetricNodes(builder, args...);
    }

    template <typename T, typename... Args>
    TString MakeGraphiteMetric(const T& first, const Args&... args) {
        TStringBuilder builder;
        builder << first;
        AppendGraphiteMetricNodes(builder, args...);
        return builder;
    }
}
