#include "async_client.h"

#include <format>

using namespace NCrypta::NGrpc;

::NGrpc::TGRpcClientConfig NCrypta::NGrpc::ConvertConfig(const TAsyncClientConfig& config) {
    const TString caLocator = TStringBuilder() << config.GetHost() << ":" << config.GetPort();
    return ::NGrpc::TGRpcClientConfig(caLocator, TDuration::Seconds(config.GetTimeoutSec()));
}

TGrpcException::TGrpcException(const ::NGrpc::TGrpcStatus& status)
    : Status(status)
    , Message(std::format("GRPC error. StatusCode = {}. InternalError = {}. Message = '{}'. Details = '{}'", status.GRpcStatusCode, status.InternalError, status.Msg.c_str(), status.Details.c_str()))
{}

const char* TGrpcException::what() const noexcept {
    return Message.c_str();
}

const ::NGrpc::TGrpcStatus& TGrpcException::GetStatus() const {
    return Status;
}
