#pragma once

#include <crypta/lib/native/grpc/async_client/proto/async_client_config.pb.h>

#include <library/cpp/grpc/client/grpc_client_low.h>
#include <yt/yt/core/actions/future.h>

#include <util/string/builder.h>

#define GRPC_ASYNC_METHOD(MethodName, TRequest, TResponse) \
NYT::TFuture<TResponse> MethodName(const TRequest& request) { \
    return TAsyncGrpcClient<TService>::Request<TRequest, TResponse>(request, &TService::Stub::Async##MethodName); \
}

namespace NCrypta::NGrpc {
    ::NGrpc::TGRpcClientConfig ConvertConfig(const TAsyncClientConfig& config);

    class TGrpcException : public yexception {
    public:
        explicit TGrpcException(const ::NGrpc::TGrpcStatus& status);
        const ::NGrpc::TGrpcStatus& GetStatus() const;
        const char* what() const noexcept override;
    private:
        ::NGrpc::TGrpcStatus Status;
        TString Message;
    };

    template<typename TGrpcService>
    class TAsyncGrpcClient {
        template<typename TRequest, typename TResponse>
        using TAsyncRequest = typename ::NGrpc::TSimpleRequestProcessor<typename TGrpcService::Stub, TRequest, TResponse>::TAsyncRequest;
    public:
        using TService = TGrpcService;

        TAsyncGrpcClient(const TAsyncClientConfig& clientConfig)
            : ClientLow(clientConfig.GetThreadsCount())
            , Connection(ClientLow.CreateGRpcServiceConnection<TGrpcService>(ConvertConfig(clientConfig)))
        {}

        template<typename TRequest, typename TResponse>
        NYT::TFuture<TResponse> Request(const TRequest& request, TAsyncRequest<TRequest, TResponse> asyncRequest) const {
            auto promise = NYT::NewPromise<TResponse>();

            ::NGrpc::TResponseCallback<TResponse> responseCb = [promise](::NGrpc::TGrpcStatus&& grpcStatus, TResponse&& response) -> void {
                if (grpcStatus.Ok()) {
                    promise.Set(std::move(response));
                } else {
                    promise.Set(NYT::TError(TGrpcException(grpcStatus)));
                }
            };

            Connection->DoRequest(request, std::move(responseCb), asyncRequest);
            return promise.ToFuture();
        }

    private:
        ::NGrpc::TGRpcClientLow ClientLow;
        std::unique_ptr<::NGrpc::TServiceConnection<TGrpcService>> Connection;
    };
}
