#include "keepalive.h"

void NCrypta::NGrpc::EnableServerKeepalive(grpc::ServerBuilder& builder, TDuration keepalivePeriod) {
    builder.AddChannelArgument(GRPC_ARG_KEEPALIVE_TIME_MS, keepalivePeriod.MilliSeconds());
    builder.AddChannelArgument(GRPC_ARG_KEEPALIVE_PERMIT_WITHOUT_CALLS, 1);
    builder.AddChannelArgument(GRPC_ARG_HTTP2_MIN_RECV_PING_INTERVAL_WITHOUT_DATA_MS, keepalivePeriod.MilliSeconds());
    builder.AddChannelArgument(GRPC_ARG_HTTP2_MIN_SENT_PING_INTERVAL_WITHOUT_DATA_MS, keepalivePeriod.MilliSeconds());
    builder.AddChannelArgument(GRPC_ARG_HTTP2_MAX_PINGS_WITHOUT_DATA, 0);
}
