#pragma once

#include <crypta/lib/native/log/log.h>

#include <library/cpp/json/json_writer.h>

#include <grpcpp/impl/codegen/interceptor.h>
#include <grpcpp/impl/codegen/server_interceptor.h>

namespace NCrypta::NGrpc {
    class TLoggingInterceptor : public grpc::experimental::Interceptor {
    public:
        using TLogHandler = std::function<void(TString&&)>;
        TLoggingInterceptor(grpc::experimental::ServerRpcInfo* info, TLogHandler& logHandler, NLog::TLogPtr log);
        void Intercept(grpc::experimental::InterceptorBatchMethods* methods) override;

    private:
        void SaveMethod(const TString& method);
        void SaveRequestMetadata(std::multimap<grpc::string_ref, grpc::string_ref>* metadata);
        void SaveRequestMessage(void* message);

        void SaveResponseMetadata(std::multimap<TString, TString>* metadata);
        void SaveResponseMessage(const void* message);
        void SaveStatus(grpc::Status status);

        void SaveSendMessageStatus(bool status);
        void WriteLog();

        TLogHandler& LogHandler;
        NLog::TLogPtr Log;
        TStringStream Stream;
        NJson::TJsonWriter Writer;
        grpc::experimental::ServerRpcInfo* Info;
        bool Disabled = false;
        TString Service;
        TString Handle;
    };
}

