#pragma once

#include "logging_interceptor.h"

#include <grpcpp/impl/codegen/interceptor.h>
#include <grpcpp/impl/codegen/server_interceptor.h>

namespace NCrypta::NGrpc {
    class TLoggingInterceptorFactory : public grpc::experimental::ServerInterceptorFactoryInterface {
    public:
        TLoggingInterceptorFactory(TLoggingInterceptor::TLogHandler logHandler, NLog::TLogPtr log);
        grpc::experimental::Interceptor* CreateServerInterceptor(grpc::experimental::ServerRpcInfo* info) override;

    private:
        TLoggingInterceptor::TLogHandler LogHandler;
        NLog::TLogPtr Log;
    };
}
