#pragma once

#include <crypta/lib/native/stats/stats.h>

#include <grpcpp/impl/codegen/interceptor.h>
#include <grpcpp/impl/codegen/server_interceptor.h>

#include <util/datetime/base.h>

namespace NCrypta::NGrpc {
    class TStatsInterceptor : public grpc::experimental::Interceptor {
    public:
        TStatsInterceptor(grpc::experimental::ServerRpcInfo* info, const TStats::TSettings& statsSettings);
        void Intercept(grpc::experimental::InterceptorBatchMethods* methods) override;

    private:
        void FinishProcessing();

        TStats& Stats;
        TInstant ArrivalTime;
        TInstant StartProcessTime;
        TString Prefix;
        bool ProcessingFinished = false;
    };
}