#pragma once

#include <util/generic/ptr.h>

namespace NCrypta {
    class ILogEntryBuilder {
    public:
        virtual ILogEntryBuilder& Add(TStringBuf key, TStringBuf value) = 0;
        virtual ILogEntryBuilder& Add(TStringBuf key, ui64 value) = 0;
        virtual TString GetAndReset() = 0;
        virtual ~ILogEntryBuilder() = default;
    };

    class ILogEntryBuilderFactory {
    public:
        virtual THolder<ILogEntryBuilder> Create() = 0;
        virtual ~ILogEntryBuilderFactory() = default;
    };

    THolder<ILogEntryBuilderFactory> NewTskvLogEntryBuilderFactory(const TString& logType);
    THolder<ILogEntryBuilderFactory> NewJsonLogEntryBuilderFactory();
}
