#include "request.h"
#include "request_parser.h"

#include <util/generic/yexception.h>

using namespace NCrypta::NHttp;

namespace {
    const TString DEFAULT_SUBCLIENT = "default";
 
    bool IsSubclientValid(const TString& subclient) {
        return std::all_of(subclient.begin(), subclient.end(), [](unsigned char c) { return std::isalnum(c) || c == '-'; });
    }
}

TRequest NRequestParser::Parse(const TCgiParameters& cgi) {
    TRequest request;

    NRequestParser::Parse(request, cgi);

    return request;
}

void NRequestParser::Parse(TRequest& request, const TCgiParameters& cgi) {
    request.Subclient = cgi.Get("subclient");

    if (!request.Subclient) {
        request.Subclient = DEFAULT_SUBCLIENT;
    }

    Y_ENSURE(IsSubclientValid(request.Subclient), "Invalid subclient: " << request.Subclient);
}
