#pragma once

#include <crypta/lib/native/dns/caching_reverse_dns_resolver.h>
#include <crypta/lib/native/http/log_entry_builder_factory.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/pqlib/producer.h>
#include <crypta/lib/native/stats/stats.h>

#include <library/cpp/http/misc/httpcodes.h>
#include <library/cpp/neh/http_common.h>

#include <util/generic/maybe.h>
#include <util/network/address.h>
#include <util/system/guard.h>
#include <util/system/sem.h>

namespace NCrypta::NHttp {
    class TRequestReply {
    public:
        TRequestReply(
            THolder<::NNeh::IHttpRequest> request,
            const NTvmAuth::TTvmClient& tvmClient,
            const TCachingReverseDnsResolver& reverseDnsResolver,
            THolder<ILogEntryBuilder>&& accessLogEntryBuilder,
            NPQ::TProducer& accessLogProducer,
            bool logBody,
            TStats& stats
        );

        TStringBuf GetRequestService();
        TStringBuf GetRequestCgi();
        TStringBuf GetRequestBody();
        TStringBuf GetRequestMethod();
        const THttpHeaders& GetRequestHeaders();
        bool IsReplied();
        TInstant GetStartTime();

        const TMaybe<NTvmAuth::TCheckedServiceTicket>& GetClientServiceTicket();
        const TMaybe<NTvmAuth::TCheckedUserTicket>& GetUserTicket();

        void Reply(HttpCodes httpCode, const TString& response, TStats& stats, NLog::TLogPtr log);
        void ReplyError(HttpCodes httpCode, const TString& errorMessage, TStats& stats, NLog::TLogPtr log);

    private:
        NAddr::TOpaqueAddr GetRemoteAddr() const;
        void SendResponse(const HttpCodes& httpCode, const TString& reply, NLog::TLogPtr& log);
        void WriteAccessLog(const HttpCodes& httpCode, const TString& body);

        void ParseTvmServiceTicket();
        void ParseTvmUserTicket();

        THolder<::NNeh::IHttpRequest> Request;
        const NTvmAuth::TTvmClient& TvmClient;
        const TCachingReverseDnsResolver& ReverseDnsResolver;
        THolder<ILogEntryBuilder> AccessLogEntryBuilder;
        NPQ::TProducer& AccessLogProducer;
        TMaybe<TMaybe<NTvmAuth::TCheckedServiceTicket>> ServiceTicket;
        TMaybe<TMaybe<NTvmAuth::TCheckedUserTicket>> UserTicket;
        bool LogBody = false;
        bool Replied = false;
        TStats& Stats;
    };
}
