#pragma once

#include "request_reply.h"

#include <crypta/lib/native/dns/reverse_dns_resolver.h>
#include <crypta/lib/native/http/log_entry_builder_factory.h>
#include <crypta/lib/native/http/proto/http_config.pb.h>
#include <crypta/lib/native/pqlib/producer.h>
#include <crypta/lib/native/stats/stats.h>

#include <library/cpp/neh/rpc.h>
#include <yt/yt/core/actions/invoker.h>
#include <yt/yt/core/concurrency/thread_pool.h>

#include <util/generic/maybe.h>
#include <util/system/sem.h>

namespace NCrypta::NHttp {
    class TServer: public ::NNeh::IOnRequest {
    public:
        using TFunc = std::function<void(TRequestReply&)>;

        TServer(
            const TFunc& func,
            const THttpConfig& config,
            const NTvmAuth::TTvmClient& tvmClient,
            const TCachingReverseDnsResolver& reverseDnsResolver,
            THolder<ILogEntryBuilderFactory> accessLogEntryBuilderFactory,
            NPQ::TProducer& accessLogProducer,
            const TStats::TSettings& statsSettings);

    private:
        virtual void OnRequest(::NNeh::IRequestRef req) override;

        NYT::NConcurrency::TThreadPoolPtr ProcessThreadPool;
        TServer::TFunc Func;
        TFastSemaphore InFlightSemaphore;
        bool LogBody = false;
        const NTvmAuth::TTvmClient& TvmClient;
        const TCachingReverseDnsResolver& ReverseDnsResolver;
        THolder<ILogEntryBuilderFactory> AccessLogEntryBuilderFactory;
        NPQ::TProducer& AccessLogProducer;
        ::NNeh::IRequesterRef Requester;

        TStats& Stats;
        NLog::TLogPtr Log;
    };
}
