#include <crypta/lib/native/id_obfuscator/puid_obfuscator.h>

#include <library/cpp/testing/benchmark/bench.h>

#include <util/generic/xrange.h>
#include <util/string/cast.h>

#include <vector>

Y_CPU_BENCHMARK(PuidHashEmptyDict, iface) {
    NCrypta::TPuidObfuscator puidObfuscator("");

    for (const auto i : xrange(iface.Iterations())) {
        TString hash = puidObfuscator.GetHash(static_cast<ui64>(i), 0).GetRef();
    }
}

Y_CPU_BENCHMARK(PuidHashStrEmptyDict, iface) {
    NCrypta::TPuidObfuscator puidObfuscator("");
    const ui64 puidCount = 1024;
    const ui64 puidBase = 1130000000000000ull;  // https://wiki.yandex-team.ru/passport/uids/

    std::vector<TString> puidStrings(puidCount);
    for (ui64 i = 0; i < puidCount; ++i) {
        puidStrings[i] = ToString(puidBase + i);
    }

    for (const auto i : xrange(iface.Iterations())) {
        TString hash = puidObfuscator.GetHash(puidStrings[i % puidCount], 0).GetRef();
    }
}
