#include "dict.h"

using namespace NCrypta::NStyx;

TDict::TDict(TStorage&& storage)
    : Storage(std::move(storage))
{
}

TMaybe<TDict::TDictEntry> TDict::GetPuidInfo(TPuid puid) const {
    if (const auto& it = Storage.find(puid); it != Storage.end()) {
        return it->second;
    } else {
        return Nothing();
    }
}

const TDict::TStorage& TDict::GetStorage() const {
    return Storage;
}
