#pragma once

#include <util/datetime/base.h>
#include <util/generic/hash.h>
#include <util/generic/maybe.h>

namespace NCrypta::NStyx {
    class TDict {
    public:
        using TPuid = ui64;
        struct TDictEntry {
            TInstant Timestamp;
            TString Hash;
            bool operator==(const TDictEntry&) const = default;
        };
        using TStorage = THashMap<TPuid, TDictEntry>;

        TDict() = default;
        explicit TDict(TStorage&& storage);

        TMaybe<TDictEntry> GetPuidInfo(TPuid puid) const;
        const TStorage& GetStorage() const;

    private:
        TStorage Storage;
    };
}
