#include "dict_serializer.h"

#include <crypta/lib/native/yaml/parse_yaml_file.h>

#include <library/cpp/yaml/as/tstring.h>

#include <util/generic/cast.h>
#include <util/stream/file.h>

#include <fstream>

using namespace NCrypta::NStyx;


void NDictSerializer::Serialize(const TDict& dict, const TString& path) {
    TFileOutput output(path);
    for (const auto& [puid, entry] : dict.GetStorage()) {
        output << "- puid: " << puid << Endl
               << "  timestamp: " << entry.Timestamp.Seconds() << Endl
               << "  hash: \"" << entry.Hash << "\"" << Endl
               ;
    }
}

namespace {
    TDict LoadFromYamlFileDoc(const std::vector<YAML::Node>& doc) {
        if (doc.size() == 0) {
            return TDict();
        }
        const auto& nodes = doc[0];
        Y_ENSURE(nodes.IsSequence());

        TDict::TStorage storage;
        for (const auto& node : nodes) {
            const auto& puid = node["puid"].as<TDict::TPuid>();
            const auto& timestamp = TInstant::Seconds(node["timestamp"].as<ui64>());
            const auto& hash = node["hash"].as<TString>();

            storage[puid] = TDict::TDictEntry{.Timestamp = timestamp, .Hash = hash};
        }

        return TDict(std::move(storage));
    }
}

TDict NDictSerializer::Deserialize(const TString& path) {
    return LoadFromYamlFileDoc(YAML::LoadAllFromFile(path));
}

TDict NDictSerializer::Deserialize(IInputStream& inputStream) {
    return LoadFromYamlFileDoc(YAML::LoadAll(inputStream.ReadAll()));
}
