#include "dynamic_puid_obfuscator.h"

using namespace NCrypta;

TDynamicPuidObfuscator::TDynamicPuidObfuscator()
    : PuidObfuscator(MakeAtomicShared<TPuidObfuscator>(TString()))
{
}

TMaybe<TPuidObfuscator::THashType> TDynamicPuidObfuscator::GetHash(TPuidObfuscator::TPuidType puid, TPuidObfuscator::TUnixtimeType unixtime) const {
    TPuidObfuscatorPtr puidObfuscatorCopy;

    {
        auto guard = Guard(Lock);
        puidObfuscatorCopy = PuidObfuscator;
    }

    return puidObfuscatorCopy->GetHash(puid, unixtime);
}

TMaybe<TPuidObfuscator::THashType> TDynamicPuidObfuscator::GetHash(TStringBuf puidStr, TPuidObfuscator::TUnixtimeType unixtime) const {
    TPuidObfuscatorPtr puidObfuscatorCopy;

    {
        auto guard = Guard(Lock);
        puidObfuscatorCopy = PuidObfuscator;
    }

    return puidObfuscatorCopy->GetHash(puidStr, unixtime);
}

void TDynamicPuidObfuscator::Swap(TPuidObfuscatorPtr newPuidObfuscator) {
    auto guard = Guard(Lock);

    PuidObfuscator.Swap(newPuidObfuscator);
}

void TDynamicPuidObfuscator::Reset(IInputStream& dictStream) {
    auto newPuidObfuscator = MakeAtomicShared<TPuidObfuscator>(dictStream);
    this->Swap(newPuidObfuscator);
}

void TDynamicPuidObfuscator::Reset(const TString& dictFilePath) {
    auto newPuidObfuscator = MakeAtomicShared<TPuidObfuscator>(dictFilePath);
    this->Swap(newPuidObfuscator);
}
