#pragma once

#include "puid_obfuscator.h"

#include <crypta/lib/native/id_obfuscator/dict/dict.h>

#include <util/generic/maybe.h>
#include <util/generic/ptr.h>
#include <util/generic/string.h>
#include <util/stream/input.h>
#include <util/system/types.h>
#include <util/system/spinlock.h>

namespace NCrypta {
    class TDynamicPuidObfuscator {
    public:
        using TPuidObfuscatorPtr = TAtomicSharedPtr<const TPuidObfuscator>;

    public:
        TDynamicPuidObfuscator();

    public:
        TMaybe<TPuidObfuscator::THashType> GetHash(TPuidObfuscator::TPuidType puid, TPuidObfuscator::TUnixtimeType unixtime) const;
        TMaybe<TPuidObfuscator::THashType> GetHash(TStringBuf puidStr, TPuidObfuscator::TUnixtimeType unixtime) const;

        void Swap(TPuidObfuscatorPtr newPuidObfuscator);
        void Reset(IInputStream& dictStream);
        void Reset(const TString& dictFilePath);

    private:
        TPuidObfuscatorPtr PuidObfuscator;
        TAdaptiveLock Lock;
    };
}
