#include "id_hash.h"

#include <util/digest/city.h>
#include <util/string/hex.h>

namespace {
    using namespace NCrypta::NStyx::NIdHashPrivate;

    const TUnixtime DEFAULT_PUID_SALT = 1'000'000'000'000'000'000ull;

    uint128 GetCityHash(TPuid puid, TUnixtime seed) {
        return CityHash128WithSeed(
                reinterpret_cast<const char*>(&puid),
                sizeof(puid),
                uint128(seed, 0)
        );
    }

    THashValue Uint128ToString(uint128 value) {
        return to_lower(HexEncode(&value.second, sizeof(value.second)) + HexEncode(&value.first, sizeof(value.first)));
    }

}

using namespace NCrypta::NStyx;

NIdHashPrivate::THashValue NIdHashPrivate::ComputeDefaultHash(TPuid puid) {
    return Uint128ToString(GetCityHash(puid, DEFAULT_PUID_SALT));
}

NIdHashPrivate::THashValue NIdHashPrivate::ComputeHash(TPuid puid, TUnixtime unixtime) {
    return Uint128ToString(GetCityHash(puid, DEFAULT_PUID_SALT + unixtime));
}
