#include "puid_obfuscator.h"

#include <crypta/lib/native/id_obfuscator/dict/dict_serializer.h>
#include <crypta/lib/native/id_obfuscator/id_hash/id_hash.h>
#include <crypta/lib/native/identifiers/lib/id_types/puid.h>

#include <util/stream/file.h>
#include <util/string/cast.h>

using namespace NCrypta;
using namespace NCrypta::NStyx;

TPuidObfuscator::TPuidObfuscator(const TString& dictFilePath)
    : Dict(dictFilePath.empty() ? TDict() : NDictSerializer::Deserialize(dictFilePath))
{
}

TPuidObfuscator::TPuidObfuscator(IInputStream& dictStream)
    : Dict(NDictSerializer::Deserialize(dictStream))
{
}

TMaybe<TPuidObfuscator::THashType> TPuidObfuscator::GetHash(TPuidType puid, TPuidObfuscator::TUnixtimeType unixtime) const {
    if (const auto& puidEntry = Dict.GetPuidInfo(puid); puidEntry.Defined()) {
        if (unixtime >= puidEntry->Timestamp.Seconds()) {
            return puidEntry->Hash;
        } else {
            return Nothing();
        }
    } else {
        return NIdHashPrivate::ComputeDefaultHash(puid);
    }
}

TMaybe<TPuidObfuscator::THashType> TPuidObfuscator::GetHash(TStringBuf puidStr, TPuidObfuscator::TUnixtimeType unixtime) const {
    return GetHash(NormalizePuid(puidStr), unixtime);
}

TPuidObfuscator::TPuidType TPuidObfuscator::NormalizePuid(TStringBuf puidStr) const {
    return FromString<TPuidType>(NIdentifiers::TPuid(puidStr).Normalize());
}
