#pragma once

#include <crypta/lib/native/id_obfuscator/dict/dict.h>

#include <util/generic/maybe.h>
#include <util/generic/string.h>
#include <util/stream/input.h>

namespace NCrypta {
    class TPuidObfuscator {
    public:
        using THashType = TString;
        using TPuidType = NStyx::TDict::TPuid;
        using TUnixtimeType = ui64;

        explicit TPuidObfuscator(const TString& dictFilePath);
        explicit TPuidObfuscator(IInputStream& dictStream);

        TMaybe<THashType> GetHash(TPuidType puid, TUnixtimeType unixtime) const;
        TMaybe<THashType> GetHash(TStringBuf puidStr, TUnixtimeType unixtime) const;

    private:
        TPuidType NormalizePuid(TStringBuf puidStr) const;

        const NCrypta::NStyx::TDict Dict;
    };
}
