#include "ads.h"

#include <ads/bsyeti/libs/proto_utils/profile_desc.h>

#include <util/string/builder.h>


TMaybe<NExperiments::EUserIdType> CryptaToStorage(const NCrypta::NIdentifiersProto::NIdType::EIdType& idType) {
    using namespace NCrypta::NIdentifiersProto;

    switch (idType) {
        case NIdType::CRYPTA_ID1:        return NExperiments::EUserIdType::UniqId;
        case NIdType::CRYPTA_ID:         return NExperiments::EUserIdType::UniqId;
        case NIdType::DUID:              return NExperiments::EUserIdType::Duid;
        case NIdType::GAID:              return NExperiments::EUserIdType::Gaid;
        case NIdType::ICOOKIE:           return NExperiments::EUserIdType::UniqId;
        case NIdType::IDFA:              return NExperiments::EUserIdType::Idfa;
        case NIdType::IFV:               return NExperiments::EUserIdType::Ifv;
        case NIdType::MM_DEVICE_ID:      return NExperiments::EUserIdType::MmDeviceId;
        case NIdType::OAID:              return NExperiments::EUserIdType::Oaid;
        case NIdType::PRIVATE_YANDEXUID: return NExperiments::EUserIdType::UniqId;
        case NIdType::PUID:              return NExperiments::EUserIdType::PassportUid;
        case NIdType::XUNIQ_GUID:        return NExperiments::EUserIdType::UniqId;
        case NIdType::YANDEXUID:         return NExperiments::EUserIdType::UniqId;
        // non-storage types
        case NIdType::ALISA_DEVICE_ID:   return Nothing();  // todo: BIGB-2402
        case NIdType::ANDROID_ID:        return Nothing();
        case NIdType::AUTO_ID:           return Nothing();
        case NIdType::AVITO_HASH:        return Nothing();
        case NIdType::AVITO_ID:          return Nothing();
        case NIdType::DIRECT_CLIENT_ID:  return Nothing();
        case NIdType::DISTR_R1:          return Nothing();
        case NIdType::DISTR_UI:          return Nothing();
        case NIdType::DIT_ID:            return Nothing();
        case NIdType::EDADEAL_UID:       return Nothing();
        case NIdType::EMAIL:             return Nothing();
        case NIdType::EMAIL_MD5:         return Nothing();
        case NIdType::EMAIL_SHA256:      return Nothing();
        case NIdType::FB_ID:             return Nothing();
        case NIdType::HOSTNAME:          return Nothing();
        case NIdType::IDFA_GAID:         return Nothing();
        case NIdType::IMEI:              return Nothing();
        case NIdType::INSTAGRAM_ID:      return Nothing();
        case NIdType::INSTAGRAM_LOGIN:   return Nothing();
        case NIdType::KINOPOISK_ID:      return Nothing();
        case NIdType::LOGIN:             return Nothing();
        case NIdType::MAC:               return Nothing();
        case NIdType::MAC_EXT:           return Nothing();
        case NIdType::MAC_EXT_MD5:       return Nothing();
        case NIdType::MD5:               return Nothing();
        case NIdType::MM_DEVICE_ID_HASH: return Nothing();
        case NIdType::OK_ID:             return Nothing();
        case NIdType::OLD_DEVICE_ID:     return Nothing();
        case NIdType::PARTNER_ID:        return Nothing();
        case NIdType::PHONE:             return Nothing();
        case NIdType::PHONE_MD5:         return Nothing();
        case NIdType::PHONE_SHA256:      return Nothing();
        case NIdType::SHA256:            return Nothing();
        case NIdType::SSP_USER_ID:       return Nothing();
        case NIdType::STAFF:             return Nothing();
        case NIdType::UUID:              return Nothing();
        case NIdType::VK_ID:             return Nothing();
        case NIdType::VK_NAME:           return Nothing();
        case NIdType::YAMONEY_ID:        return Nothing();
        case NIdType::YSCLID:            return Nothing();
        // defaults
        case NIdType::DEFAULT:                              return Nothing();
        case NIdType::EIdType_INT_MIN_SENTINEL_DO_NOT_USE_: return Nothing();
        case NIdType::EIdType_INT_MAX_SENTINEL_DO_NOT_USE_: return Nothing();
    }
}

TMaybe<yabs::proto::Profile::TSourceUniq::EIdType> CryptaToAds(const NCrypta::NIdentifiersProto::NIdType::EIdType& idType) {
    using TSourceUniq = yabs::proto::Profile::TSourceUniq;
    using namespace NCrypta::NIdentifiersProto;

    switch (idType) {
        case NIdType::CRYPTA_ID1:        return TSourceUniq::CRYPTA_ID1;
        case NIdType::CRYPTA_ID:         return TSourceUniq::CRYPTA_ID2;
        case NIdType::DUID:              return TSourceUniq::DUID;
        case NIdType::EMAIL_MD5:         return TSourceUniq::EMAIL_MD5;
        case NIdType::GAID:              return TSourceUniq::GAID;
        case NIdType::ICOOKIE:           return TSourceUniq::YANDEX_UID; // treat ICOOKIE exactly like YANDEXUID
        case NIdType::IDFA:              return TSourceUniq::IDFA;
        case NIdType::IFV:               return TSourceUniq::IFV;
        case NIdType::MAC:               return TSourceUniq::MAC;
        case NIdType::MAC_EXT_MD5:       return TSourceUniq::MAC_EXT_MD5;
        case NIdType::MM_DEVICE_ID:      return TSourceUniq::MM_DEVICE_ID;
        case NIdType::OAID:              return TSourceUniq::OAID;
        case NIdType::PHONE_MD5:         return TSourceUniq::PHONE_MD5;
        case NIdType::PRIVATE_YANDEXUID: return TSourceUniq::PRIVATE_YANDEX_UID;
        case NIdType::PUID:              return TSourceUniq::PUID;
        case NIdType::SSP_USER_ID:       return TSourceUniq::SSP_USER_ID;
        case NIdType::UUID:              return TSourceUniq::UUID;
        case NIdType::XUNIQ_GUID:        return TSourceUniq::XUNIQ_GUID;
        case NIdType::YANDEXUID:         return TSourceUniq::YANDEX_UID;
        // not yabs ids
        case NIdType::ALISA_DEVICE_ID:   return Nothing();  // todo: BIGB-2402
        case NIdType::ANDROID_ID:        return Nothing();
        case NIdType::AUTO_ID:           return Nothing();
        case NIdType::AVITO_HASH:        return Nothing();
        case NIdType::AVITO_ID:          return Nothing();
        case NIdType::DIRECT_CLIENT_ID:  return Nothing();
        case NIdType::DISTR_R1:          return Nothing();
        case NIdType::DISTR_UI:          return Nothing();
        case NIdType::DIT_ID:            return Nothing();
        case NIdType::EDADEAL_UID:       return Nothing();
        case NIdType::EMAIL:             return Nothing();
        case NIdType::EMAIL_SHA256:      return Nothing();
        case NIdType::FB_ID:             return Nothing();
        case NIdType::IDFA_GAID:         return Nothing();
        case NIdType::IMEI:              return Nothing();
        case NIdType::KINOPOISK_ID:      return Nothing();
        case NIdType::LOGIN:             return Nothing();
        case NIdType::MAC_EXT:           return Nothing();
        case NIdType::MD5:               return Nothing();
        case NIdType::MM_DEVICE_ID_HASH: return Nothing();
        case NIdType::OK_ID:             return Nothing();
        case NIdType::PARTNER_ID:        return Nothing();
        case NIdType::PHONE:             return Nothing();
        case NIdType::PHONE_SHA256:      return Nothing();
        case NIdType::SHA256:            return Nothing();
        case NIdType::VK_ID:             return Nothing();
        case NIdType::VK_NAME:           return Nothing();
        case NIdType::YAMONEY_ID:        return Nothing();
        // non identifier ids
        case NIdType::HOSTNAME:          return Nothing();
        case NIdType::INSTAGRAM_ID:      return Nothing();
        case NIdType::INSTAGRAM_LOGIN:   return Nothing();
        case NIdType::OLD_DEVICE_ID:     return Nothing();
        case NIdType::STAFF:             return Nothing();
        case NIdType::YSCLID:            return Nothing();
        // special case for skip default clause
        case NIdType::DEFAULT:                              return Nothing();
        case NIdType::EIdType_INT_MIN_SENTINEL_DO_NOT_USE_: return Nothing();
        case NIdType::EIdType_INT_MAX_SENTINEL_DO_NOT_USE_: return Nothing();
    }
}

bool IsProfileType(const NCrypta::NIdentifiersProto::NIdType::EIdType& idType){
    return ProfileTypes.contains(idType);
}

TMaybe<TString> ConvertToProfileUniq(const NCrypta::NIdentifiersProto::NIdType::EIdType& idType, const TString& id) {
    if (!IsProfileType(idType)) {
        return Nothing();
    }

    const auto keyYabsType{CryptaToAds(idType)};
    static const NBSYeti::TIdentTypeConverter enumConverter;

    return TStringBuilder{}
           << enumConverter.GetTupleByMainValue(*keyYabsType).IdPrefix
           << id;
}

TMaybe<TString> ConvertToStorageId(const NCrypta::NIdentifiersProto::NIdType::EIdType& idType, const TString& id) {
    if (!IsProfileType(idType)) {
        return Nothing();
    }

    const auto& storageIdType{CryptaToStorage(idType)};
    return NExperiments::ConvertToStorageUid(id, *storageIdType);
}
