#pragma once

#include <util/generic/hash_set.h>
#include <util/generic/maybe.h>

#include <ads/bsyeti/libs/experiments/user_ids/user_ids.h>
#include <yabs/proto/user_profile.pb.h>

#include <crypta/lib/proto/identifiers/id_type.pb.h>

// see https://a.yandex-team.ru/arc_vcs/yabs/proto/user_profile.proto?rev=r9180105#L593
// and https://a.yandex-team.ru/arc_vcs/ads/bsyeti/eagle/libs/miner/uid_extractor.cpp?rev=r9180107#L27
const auto ProfileTypes = THashSet<NCrypta::NIdentifiersProto::NIdType::EIdType>{
    NCrypta::NIdentifiersProto::NIdType::DUID,
    NCrypta::NIdentifiersProto::NIdType::GAID,
    NCrypta::NIdentifiersProto::NIdType::OAID,
    NCrypta::NIdentifiersProto::NIdType::PUID,
    NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID,
    NCrypta::NIdentifiersProto::NIdType::IDFA,
    NCrypta::NIdentifiersProto::NIdType::IFV,

    NCrypta::NIdentifiersProto::NIdType::PRIVATE_YANDEXUID,
    NCrypta::NIdentifiersProto::NIdType::YANDEXUID,
    NCrypta::NIdentifiersProto::NIdType::XUNIQ_GUID,
    NCrypta::NIdentifiersProto::NIdType::CRYPTA_ID1,
    NCrypta::NIdentifiersProto::NIdType::CRYPTA_ID,

    // icookie behaves like YANDEXUID on multiple occasions
    NCrypta::NIdentifiersProto::NIdType::ICOOKIE,
};

TMaybe<yabs::proto::Profile::TSourceUniq::EIdType> CryptaToAds(const NCrypta::NIdentifiersProto::NIdType::EIdType& idType);
TMaybe<NExperiments::EUserIdType> CryptaToStorage(const NCrypta::NIdentifiersProto::NIdType::EIdType& idType);

bool IsProfileType(const NCrypta::NIdentifiersProto::NIdType::EIdType& idType);

TMaybe<TString> ConvertToProfileUniq(const NCrypta::NIdentifiersProto::NIdType::EIdType& idType, const TString& id);
TMaybe<TString> ConvertToStorageId(const NCrypta::NIdentifiersProto::NIdType::EIdType& idType, const TString& id);
