#pragma once

#include <util/generic/hash_set.h>

namespace NIdentifiers {
    class TYandexuid;
    class TMmDeviceId;
    class TUuid;
    class TPuid;

    namespace NBlackList {
        using TBlackList = THashSet<TString>;

        template <typename T> const TBlackList& GetBlackList() {
            const static TBlackList empty;
            return empty;
        };

        template<> const TBlackList& GetBlackList<TYandexuid>();
        template<> const TBlackList& GetBlackList<TMmDeviceId>();
        template<> const TBlackList& GetBlackList<TUuid>();
        template<> const TBlackList& GetBlackList<TPuid>();
    }
}
