#include <crypta/lib/native/identifiers/lib/blacklist.h>

#include <library/cpp/resource/resource.h>
#include <library/cpp/string_utils/csv/csv.h>
#include <util/generic/hash.h>
#include <util/generic/string.h>
#include <util/string/split.h>

namespace {
    using TBlackListMap = THashMap<TString, NIdentifiers::NBlackList::TBlackList>;
    TBlackListMap ParseResource() {
        TBlackListMap listMap{};
        for (TStringBuf lineBuf : StringSplitter(NResource::Find("/blacklist.csv")).Split('\n').SkipEmpty()) {
            TString line{lineBuf};
            auto splitter = NCsvFormat::CsvSplitter(line);
            TString key{splitter.Consume()};
            splitter.Step();
            TString value{splitter.Consume()};
            listMap[key].insert(value);
        }
        return listMap;
    };

    const static TBlackListMap blackListMap{ParseResource()};
}

namespace NIdentifiers::NBlackList {
    template <>
    const TBlackList& GetBlackList<TMmDeviceId>() {
        return blackListMap.at("mm_device_id");
    }

    template <>
    const TBlackList& GetBlackList<TYandexuid>() {
        return blackListMap.at("yandexuid");
    }

    template <>
    const TBlackList& GetBlackList<TUuid>() {
        return blackListMap.at("uuid");
    }

    template <>
    const TBlackList& GetBlackList<TPuid>() {
        return blackListMap.at("puid");
    }
}
