#pragma once

#include "identifier.h"
#include <util/generic/maybe.h>
#include <util/string/builder.h>
#include <util/digest/murmur.h>

namespace NIdentifiers {
    class TGenericID;
}

bool operator==(const NIdentifiers::TIdentifier& other,
                const NIdentifiers::TGenericID& self);

namespace NIdentifiers {
    class TGenericID {
    public:
        explicit TGenericID(const NCrypta::NIdentifiersProto::TGenericID&);
        explicit TGenericID(const EIdType&, const TString& = "");
        explicit TGenericID(const TString&, const TString& = "");
        TGenericID(const TGenericID& other);
        TGenericID(TGenericID&& other);

        static TString Next(const EIdType&);

        bool IsValid() const;
        bool IsSignificant() const;
        size_t Hash() const;

        template <class ValueType>
        void SetValue(const ValueType&);
        void SetValue(const char*);

        TString GetMd5() const;
        TString GetSha256() const;
        ui64 GetHalf() const;

        bool HasLikelihood() const;
        double GetFrequencySpread();
        double GetAlternating();
        double GetPeriodicity();
        double GetRepetitions();

        explicit operator ui64() const {
            if (Identifier != nullptr) {
                return static_cast<ui64>(*Identifier);
            }
            return 0;
        }

        explicit operator NCrypta::NIdentifiersProto::UInt256() const {
            if (Identifier != nullptr) {
                return static_cast<NCrypta::NIdentifiersProto::UInt256>(*Identifier);
            }
            return NCrypta::NIdentifiersProto::UInt256();
        }

        TString Normalize() const;
        TString StrictNormalize() const;
        TString GetValue() const;
        TString GetNext() const;

        EIdType GetType() const;
        TString GetTypeString() const;

        bool operator==(const TGenericID&) const;
        bool operator==(const TIdentifier&) const;
        friend bool (::operator==)(const TIdentifier&, const TGenericID&);

        NCrypta::NIdentifiersProto::TGenericID ToProto() const;
        TString Serialize() const;

    private:
        EIdType Type;
        THolder<TIdentifier> Identifier;
    };
}

// define custom hash function for identifiers
template <>
struct THash<NIdentifiers::TGenericID> {
    size_t operator()(const NIdentifiers::TGenericID& identifier) const {
        return identifier.Hash();
    }
};
