#include "alisa_device_id.h"

namespace NIdentifiers {
    bool TAlisaDeviceId::Validate(const TString& value) {
        return RE2::FullMatch(value, ALISA_DEVICE_ID_REGEXP);
    }

    TString TAlisaDeviceId::Next() {
        TString output;
        for (size_t index = 0; index < 32; ++index) {
            output.append(NextHexDigest());
        }
        return output;
    }

    NCrypta::NIdentifiersProto::TGenericID TAlisaDeviceId::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutableAlisaDeviceId()->SetValue(Normalize());
        }
        return proto;
    }

    TString TAlisaDeviceId::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : proto.GetAlisaDeviceId().GetValue();
    }
}
