#pragma once

#include <crypta/lib/native/identifiers/lib/identifier.h>

#include <contrib/libs/re2/re2/re2.h>

static const re2::RE2 ALISA_DEVICE_ID_REGEXP("[0-9a-zA-Z\\-]{8,36}");

namespace NIdentifiers {
    class TAlisaDeviceId: public TTypedIdentifier<TAlisaDeviceId, NCrypta::NIdentifiersProto::NIdType::ALISA_DEVICE_ID> {
    public:
        using TTypedIdentifier::TTypedIdentifier;
        static const size_t MIN_SIGNIFICANT_COUNT{1};
        static size_t CountSignificant(const TString& value) {
            return CountSignificantUniq(value);
        }

        static TString Next();

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        static bool Validate(const TString&);
    };
}
