#pragma once

#include "alisa_device_id.h"
#include "android_id.h"
#include "auto_id.h"
#include "avito_hash.h"
#include "avito_id.h"
#include "cryptaid.h"
#include "direct_client_id.h"
#include "distrr1.h"
#include "distrui.h"
#include "dit_id.h"
#include "duid.h"
#include "edadeal_uid.h"
#include "email.h"
#include "fb_id.h"
#include "gaid.h"
#include "hostname.h"
#include "icookie.h"
#include "idfa.h"
#include "idfa_gaid.h"
#include "ifv.h"
#include "imei.h"
#include "kp_id.h"
#include "login.h"
#include "mac.h"
#include "mac_ext.h"
#include "md5.h"
#include "mm_device_id.h"
#include "mm_device_id_hash.h"
#include "oaid.h"
#include "ok_id.h"
#include "partner_record_id.h"
#include "phone.h"
#include "puid.h"
#include "sha256.h"
#include "ssp.h"
#include "uuid.h"
#include "vk_id.h"
#include "vk_name.h"
#include "xuniqguid.h"
#include "yamoney_id.h"
#include "yandexuid.h"
#include "ysclid.h"

#include <util/generic/hash.h>
#include <util/generic/string.h>
#include <util/string/cast.h>
#include <util/string/split.h>

namespace NIdentifiers {

    template <class ValueType>
    using TMapOfIdentifierConstruct = THashMap<NCrypta::NIdentifiersProto::NIdType::EIdType,
                                               THolder<TIdentifier>(*)(const ValueType&)>;
    using TMapOfIdentifierNext = THashMap<NCrypta::NIdentifiersProto::NIdType::EIdType, TString(*)()>;
    using TMapOfIdentifierTypes = THashMap<TString, NCrypta::NIdentifiersProto::NIdType::EIdType>;

    template <class IdentifierType, class ValueType>
    THolder<TIdentifier> ConstructIdentifier(const ValueType& value) {
        return MakeHolder<IdentifierType>(value);
    }

    template <class ValueType>
    static const TMapOfIdentifierConstruct<ValueType> IDENTIFIERS_MAP({
        // {NCrypta::NIdentifiersProto::NIdType::DEFAULT,              &ConstructIdentifier<>},
        {NCrypta::NIdentifiersProto::NIdType::ALISA_DEVICE_ID,      &ConstructIdentifier<TAlisaDeviceId>},
        {NCrypta::NIdentifiersProto::NIdType::ANDROID_ID,           &ConstructIdentifier<TAndroidId>},
        {NCrypta::NIdentifiersProto::NIdType::AVITO_HASH,           &ConstructIdentifier<TAvitoHash>},
        {NCrypta::NIdentifiersProto::NIdType::AVITO_ID,             &ConstructIdentifier<TAvitoId>},
        {NCrypta::NIdentifiersProto::NIdType::AUTO_ID,              &ConstructIdentifier<TAutoId>},
        {NCrypta::NIdentifiersProto::NIdType::CRYPTA_ID,            &ConstructIdentifier<TCryptaId>},
        {NCrypta::NIdentifiersProto::NIdType::DIRECT_CLIENT_ID,     &ConstructIdentifier<TDirectClientId>},
        {NCrypta::NIdentifiersProto::NIdType::DISTR_R1,             &ConstructIdentifier<TDistrR1>},
        {NCrypta::NIdentifiersProto::NIdType::DISTR_UI,             &ConstructIdentifier<TDistrUI>},
        {NCrypta::NIdentifiersProto::NIdType::DIT_ID,               &ConstructIdentifier<TDitId>},
        {NCrypta::NIdentifiersProto::NIdType::DUID,                 &ConstructIdentifier<TDuid>},
        {NCrypta::NIdentifiersProto::NIdType::EDADEAL_UID,          &ConstructIdentifier<TEdadealUid>},
        {NCrypta::NIdentifiersProto::NIdType::EMAIL,                &ConstructIdentifier<TEmail>},
        {NCrypta::NIdentifiersProto::NIdType::EMAIL_MD5,            &ConstructIdentifier<TEmailMd5>},
        {NCrypta::NIdentifiersProto::NIdType::EMAIL_SHA256,         &ConstructIdentifier<TEmailSha256>},
        {NCrypta::NIdentifiersProto::NIdType::FB_ID,                &ConstructIdentifier<TFbId>},
        {NCrypta::NIdentifiersProto::NIdType::GAID,                 &ConstructIdentifier<TGaid>},
        {NCrypta::NIdentifiersProto::NIdType::HOSTNAME,             &ConstructIdentifier<THostname>},
        {NCrypta::NIdentifiersProto::NIdType::ICOOKIE,              &ConstructIdentifier<TIcookie>},
        {NCrypta::NIdentifiersProto::NIdType::IDFA,                 &ConstructIdentifier<TIdfa>},
        {NCrypta::NIdentifiersProto::NIdType::IDFA_GAID,            &ConstructIdentifier<TIdfaGaid>},
        {NCrypta::NIdentifiersProto::NIdType::IFV,                  &ConstructIdentifier<TIfv>},
        {NCrypta::NIdentifiersProto::NIdType::IMEI,                 &ConstructIdentifier<TImei>},
        {NCrypta::NIdentifiersProto::NIdType::KINOPOISK_ID,         &ConstructIdentifier<TKpId>},
        {NCrypta::NIdentifiersProto::NIdType::LOGIN,                &ConstructIdentifier<TLogin>},
        {NCrypta::NIdentifiersProto::NIdType::MAC_EXT,              &ConstructIdentifier<TMacExt>},
        {NCrypta::NIdentifiersProto::NIdType::MAC_EXT_MD5,          &ConstructIdentifier<TMacExtMd5>},
        {NCrypta::NIdentifiersProto::NIdType::MAC,                  &ConstructIdentifier<TMac>},
        {NCrypta::NIdentifiersProto::NIdType::MD5,                  &ConstructIdentifier<TMd5>},
        {NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID,         &ConstructIdentifier<TMmDeviceId>},
        {NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID_HASH,    &ConstructIdentifier<TMmDeviceIdHash>},
        {NCrypta::NIdentifiersProto::NIdType::OAID,                 &ConstructIdentifier<TOaid>},
        {NCrypta::NIdentifiersProto::NIdType::OK_ID,                &ConstructIdentifier<TOkId>},
        {NCrypta::NIdentifiersProto::NIdType::PARTNER_ID,           &ConstructIdentifier<TPartnerRecordId>},
        {NCrypta::NIdentifiersProto::NIdType::PHONE,                &ConstructIdentifier<TPhone>},
        {NCrypta::NIdentifiersProto::NIdType::PHONE_MD5,            &ConstructIdentifier<TPhoneMd5>},
        {NCrypta::NIdentifiersProto::NIdType::PHONE_SHA256,         &ConstructIdentifier<TPhoneSha256>},
        {NCrypta::NIdentifiersProto::NIdType::PUID,                 &ConstructIdentifier<TPuid>},
        {NCrypta::NIdentifiersProto::NIdType::SHA256,               &ConstructIdentifier<TSha256>},
        {NCrypta::NIdentifiersProto::NIdType::SSP_USER_ID,          &ConstructIdentifier<TSspUserId>},
        {NCrypta::NIdentifiersProto::NIdType::UUID,                 &ConstructIdentifier<TUuid>},
        {NCrypta::NIdentifiersProto::NIdType::VK_ID,                &ConstructIdentifier<TVkId>},
        {NCrypta::NIdentifiersProto::NIdType::VK_NAME,              &ConstructIdentifier<TVkName>},
        {NCrypta::NIdentifiersProto::NIdType::XUNIQ_GUID,           &ConstructIdentifier<TXUniqGuid>},
        {NCrypta::NIdentifiersProto::NIdType::YAMONEY_ID,           &ConstructIdentifier<TYamoneyId>},
        {NCrypta::NIdentifiersProto::NIdType::YANDEXUID,            &ConstructIdentifier<TYandexuid>},
        {NCrypta::NIdentifiersProto::NIdType::YSCLID,               &ConstructIdentifier<TYSClid>},
    });

    static const TMapOfIdentifierNext IDENTIFIERS_NEXT_MAP({
        {NCrypta::NIdentifiersProto::NIdType::ALISA_DEVICE_ID,      &TAlisaDeviceId::Next},
        {NCrypta::NIdentifiersProto::NIdType::ANDROID_ID,           &TAndroidId::Next},
        {NCrypta::NIdentifiersProto::NIdType::AUTO_ID,              &TAutoId::Next},
        {NCrypta::NIdentifiersProto::NIdType::AVITO_HASH,           &TAvitoHash::Next},
        {NCrypta::NIdentifiersProto::NIdType::AVITO_ID,             &TAvitoId::Next},
        {NCrypta::NIdentifiersProto::NIdType::CRYPTA_ID,            &TCryptaId::Next},
        {NCrypta::NIdentifiersProto::NIdType::DIRECT_CLIENT_ID,     &TDirectClientId::Next},
        {NCrypta::NIdentifiersProto::NIdType::DISTR_R1,             &TDistrR1::Next},
        {NCrypta::NIdentifiersProto::NIdType::DISTR_UI,             &TDistrUI::Next},
        {NCrypta::NIdentifiersProto::NIdType::DIT_ID,               &TDitId::Next},
        {NCrypta::NIdentifiersProto::NIdType::DUID,                 &TDuid::Next},
        {NCrypta::NIdentifiersProto::NIdType::EDADEAL_UID,          &TEdadealUid::Next},
        {NCrypta::NIdentifiersProto::NIdType::EMAIL,                &TEmail::Next},
        {NCrypta::NIdentifiersProto::NIdType::EMAIL_MD5,            &TEmailMd5::Next},
        {NCrypta::NIdentifiersProto::NIdType::EMAIL_SHA256,         &TEmailSha256::Next},
        {NCrypta::NIdentifiersProto::NIdType::FB_ID,                &TFbId::Next},
        {NCrypta::NIdentifiersProto::NIdType::GAID,                 &TGaid::Next},
        {NCrypta::NIdentifiersProto::NIdType::HOSTNAME,             &THostname::Next},
        {NCrypta::NIdentifiersProto::NIdType::ICOOKIE,              &TIcookie::Next},
        {NCrypta::NIdentifiersProto::NIdType::IDFA,                 &TIdfa::Next},
        {NCrypta::NIdentifiersProto::NIdType::IDFA_GAID,            &TIdfaGaid::Next},
        {NCrypta::NIdentifiersProto::NIdType::IFV,                  &TIfv::Next},
        {NCrypta::NIdentifiersProto::NIdType::IMEI,                 &TImei::Next},
        {NCrypta::NIdentifiersProto::NIdType::KINOPOISK_ID,         &TKpId::Next},
        {NCrypta::NIdentifiersProto::NIdType::LOGIN,                &TLogin::Next},
        {NCrypta::NIdentifiersProto::NIdType::MAC,                  &TMac::Next},
        {NCrypta::NIdentifiersProto::NIdType::MAC_EXT,              &TMacExt::Next},
        {NCrypta::NIdentifiersProto::NIdType::MAC_EXT_MD5,          &TMacExtMd5::Next},
        {NCrypta::NIdentifiersProto::NIdType::MD5,                  &TMd5::Next},
        {NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID,         &TMmDeviceId::Next},
        {NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID_HASH,    &TMmDeviceIdHash::Next},
        {NCrypta::NIdentifiersProto::NIdType::OAID,                 &TOaid::Next},
        {NCrypta::NIdentifiersProto::NIdType::OK_ID,                &TOkId::Next},
        {NCrypta::NIdentifiersProto::NIdType::PARTNER_ID,           &TPartnerRecordId::Next},
        {NCrypta::NIdentifiersProto::NIdType::PHONE,                &TPhone::Next},
        {NCrypta::NIdentifiersProto::NIdType::PHONE_MD5,            &TPhoneMd5::Next},
        {NCrypta::NIdentifiersProto::NIdType::PHONE_SHA256,         &TPhoneSha256::Next},
        {NCrypta::NIdentifiersProto::NIdType::PUID,                 &TPuid::Next},
        {NCrypta::NIdentifiersProto::NIdType::SHA256,               &TSha256::Next},
        {NCrypta::NIdentifiersProto::NIdType::SSP_USER_ID,          &TSspUserId::Next},
        {NCrypta::NIdentifiersProto::NIdType::UUID,                 &TUuid::Next},
        {NCrypta::NIdentifiersProto::NIdType::VK_ID,                &TVkId::Next},
        {NCrypta::NIdentifiersProto::NIdType::VK_NAME,              &TVkName::Next},
        {NCrypta::NIdentifiersProto::NIdType::XUNIQ_GUID,           &TXUniqGuid::Next},
        {NCrypta::NIdentifiersProto::NIdType::YAMONEY_ID,           &TYamoneyId::Next},
        {NCrypta::NIdentifiersProto::NIdType::YANDEXUID,            &TYandexuid::Next},
        {NCrypta::NIdentifiersProto::NIdType::YSCLID,               &TYSClid::Next},
    });

    static const TMapOfIdentifierTypes IDENTIFIERS_NAME_TO_TYPE({
        {"alisa",                   NCrypta::NIdentifiersProto::NIdType::ALISA_DEVICE_ID},
        {"alisa_id",                NCrypta::NIdentifiersProto::NIdType::ALISA_DEVICE_ID},
        {"alisa_device_id",         NCrypta::NIdentifiersProto::NIdType::ALISA_DEVICE_ID},
        {"android_id",              NCrypta::NIdentifiersProto::NIdType::ANDROID_ID},
        {"auto_id",                 NCrypta::NIdentifiersProto::NIdType::AUTO_ID},
        {"avito_hash",              NCrypta::NIdentifiersProto::NIdType::AVITO_HASH},
        {"avito_id",                NCrypta::NIdentifiersProto::NIdType::AVITO_ID},
        {"crypta_id",               NCrypta::NIdentifiersProto::NIdType::CRYPTA_ID},
        {"cryptaid",                NCrypta::NIdentifiersProto::NIdType::CRYPTA_ID},
        {"device_id",               NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID},
        {"deviceid",                NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID},
        {"devid",                   NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID},
        {"devidhash",               NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID_HASH},
        {"direct_client_id",        NCrypta::NIdentifiersProto::NIdType::DIRECT_CLIENT_ID},
        {"distr_r1",                NCrypta::NIdentifiersProto::NIdType::DISTR_R1},
        {"distr_ui",                NCrypta::NIdentifiersProto::NIdType::DISTR_UI},
        {"dit_id",                  NCrypta::NIdentifiersProto::NIdType::DIT_ID},
        {"duid",                    NCrypta::NIdentifiersProto::NIdType::DUID},
        {"edadeal",                 NCrypta::NIdentifiersProto::NIdType::EDADEAL_UID},
        {"edadeal_uid",             NCrypta::NIdentifiersProto::NIdType::EDADEAL_UID},
        {"email",                   NCrypta::NIdentifiersProto::NIdType::EMAIL},
        {"email_md5",               NCrypta::NIdentifiersProto::NIdType::EMAIL_MD5},
        {"email_sha256",            NCrypta::NIdentifiersProto::NIdType::EMAIL_SHA256},
        {"fb_id",                   NCrypta::NIdentifiersProto::NIdType::FB_ID},
        {"gaid",                    NCrypta::NIdentifiersProto::NIdType::GAID},
        {"hostname",                NCrypta::NIdentifiersProto::NIdType::HOSTNAME},
        {"icookie",                 NCrypta::NIdentifiersProto::NIdType::ICOOKIE},
        {"idfa",                    NCrypta::NIdentifiersProto::NIdType::IDFA},
        {"idfa_gaid",               NCrypta::NIdentifiersProto::NIdType::IDFA_GAID},
        {"idfagaid",                NCrypta::NIdentifiersProto::NIdType::IDFA_GAID},
        {"idfv",                    NCrypta::NIdentifiersProto::NIdType::IFV},
        {"ifv",                     NCrypta::NIdentifiersProto::NIdType::IFV},
        {"imei",                    NCrypta::NIdentifiersProto::NIdType::IMEI},
        {"kp_id",                   NCrypta::NIdentifiersProto::NIdType::KINOPOISK_ID},
        {"login",                   NCrypta::NIdentifiersProto::NIdType::LOGIN},
        {"mac",                     NCrypta::NIdentifiersProto::NIdType::MAC},
        {"mac_ext",                 NCrypta::NIdentifiersProto::NIdType::MAC_EXT},
        {"mac_ext_md5",             NCrypta::NIdentifiersProto::NIdType::MAC_EXT_MD5},
        {"md5",                     NCrypta::NIdentifiersProto::NIdType::MD5},
        {"mm_device_id",            NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID},
        {"mm_device_id_hash",       NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID_HASH},
        {"mmdeviceid",              NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID},
        {"mmdi",                    NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID},
        {"mmetric_device_id",       NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID},
        {"mmetric_device_id_hash",  NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID_HASH},
        {"mmetric_devids",          NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID},
        {"new-generated-yandex-uid",         NCrypta::NIdentifiersProto::NIdType::YANDEXUID},
        {"oaid",                    NCrypta::NIdentifiersProto::NIdType::OAID},
        {"ok_id",                   NCrypta::NIdentifiersProto::NIdType::OK_ID},
        {"okid",                    NCrypta::NIdentifiersProto::NIdType::OK_ID},
        {"open_id",                 NCrypta::NIdentifiersProto::NIdType::OAID},
        {"partner_record_id",       NCrypta::NIdentifiersProto::NIdType::PARTNER_ID},
        {"phone",                   NCrypta::NIdentifiersProto::NIdType::PHONE},
        {"phone_md5",               NCrypta::NIdentifiersProto::NIdType::PHONE_MD5},
        {"phone_sha256",            NCrypta::NIdentifiersProto::NIdType::PHONE_SHA256},
        {"puid",                    NCrypta::NIdentifiersProto::NIdType::PUID},
        {"sha256",                  NCrypta::NIdentifiersProto::NIdType::SHA256},
        {"shyid",                            NCrypta::NIdentifiersProto::NIdType::YANDEXUID},
        {"ssp_user_id",             NCrypta::NIdentifiersProto::NIdType::SSP_USER_ID},
        {"turbo-yandex-uid",                 NCrypta::NIdentifiersProto::NIdType::YANDEXUID},
        {"uuid",                    NCrypta::NIdentifiersProto::NIdType::UUID},
        {"vk",                      NCrypta::NIdentifiersProto::NIdType::VK_ID},
        {"vk_id",                   NCrypta::NIdentifiersProto::NIdType::VK_ID},
        {"vk_name",                 NCrypta::NIdentifiersProto::NIdType::VK_NAME},
        {"vkid",                    NCrypta::NIdentifiersProto::NIdType::VK_ID},
        {"xuniq_guid",              NCrypta::NIdentifiersProto::NIdType::XUNIQ_GUID},
        {"yamoney_id",              NCrypta::NIdentifiersProto::NIdType::YAMONEY_ID},
        {"yandex-uid",                       NCrypta::NIdentifiersProto::NIdType::YANDEXUID},
        {"yandex-uid-cookie",                NCrypta::NIdentifiersProto::NIdType::YANDEXUID},
        {"yandex-uid-identify-cookie-match", NCrypta::NIdentifiersProto::NIdType::YANDEXUID},
        {"yandex-uid-query",                 NCrypta::NIdentifiersProto::NIdType::YANDEXUID},
        {"yandexuid",                        NCrypta::NIdentifiersProto::NIdType::YANDEXUID},
        {"ysclid",                  NCrypta::NIdentifiersProto::NIdType::YSCLID},
        {"yuid",                             NCrypta::NIdentifiersProto::NIdType::YANDEXUID},
    });

    static const TMapOfIdentifierTypes IDENTIFIERS_PROTO_NAMES = []() -> TMapOfIdentifierTypes {
        TMapOfIdentifierTypes embedded_map;
        for (const auto& [enum_item, _] : IDENTIFIERS_NEXT_MAP) {
            const TString enum_name = NCrypta::NIdentifiersProto::NIdType::EIdType_Name(enum_item);
            TString camel_name;
            for (const auto& iterator : StringSplitter(enum_name).Split('_')) {
                camel_name.append(to_title(ToString(iterator.Token())));
            }
            embedded_map[camel_name] = enum_item;
        }
        return embedded_map;
    }();

    inline NCrypta::NIdentifiersProto::NIdType::EIdType GetIdentifierTypeByName(const TString& name) {
        if (const auto& iterator{IDENTIFIERS_NAME_TO_TYPE.find(name)};
            iterator == IDENTIFIERS_NAME_TO_TYPE.end()) {
            ythrow yexception() << "Identifier '" << name << "' not found";
        } else {
            return iterator->second;
        }
    };

    inline NCrypta::NIdentifiersProto::NIdType::EIdType GetIdentifierTypeByNameOrDefault(const TString& name) {
        if (const auto& iterator{IDENTIFIERS_NAME_TO_TYPE.find(name)};
            iterator == IDENTIFIERS_NAME_TO_TYPE.end()) {
            return NCrypta::NIdentifiersProto::NIdType::DEFAULT;
        } else {
            return iterator->second;
        }
    };
};
