#include "android_id.h"
#include <util/string/cast.h>

namespace NIdentifiers {
    bool TAndroidId::Validate(const TString& value) {
        return RE2::FullMatch(value, ANDROID_ID_REGEXP);
    }

    TString TAndroidId::DoNormalize() const {
        return to_lower(Original);
    }

    TString TAndroidId::Next() {
        TString output;
        for (size_t index = 0; index < 16; ++index) {
            output.append(NextHexDigest());
        }
        return output;
    }

    NCrypta::NIdentifiersProto::TGenericID TAndroidId::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            auto protoInt = IntFromString<ui64, 16>(Normalize());
            proto.MutableAndroidId()->SetValue(protoInt);
        }
        return proto;
    }

    TString TAndroidId::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : UIntToHex(proto.GetAndroidId().GetValue());
    }
}
