#pragma once

#include <crypta/lib/native/identifiers/lib/identifier.h>

#include <contrib/libs/re2/re2/re2.h>

static const re2::RE2 ANDROID_ID_REGEXP("[0-9a-fA-F]{16}");

namespace NIdentifiers {
    class TAndroidId: public TTypedIdentifier<TAndroidId, NCrypta::NIdentifiersProto::NIdType::ANDROID_ID> {
    public:
        using TTypedIdentifier::TTypedIdentifier;

        static TString Next();

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        static bool Validate(const TString&);
    protected:
        TString DoNormalize() const override;
    };
}
