#include "auto_id.h"

#include <util/string/cast.h>

namespace NIdentifiers {
    bool TAutoId::Validate(const TString& value) {
        return IsUint64(value);
    }

    TString TAutoId::Next() {
        return NextNonZeroUInt();
    }

    NCrypta::NIdentifiersProto::TGenericID TAutoId::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutableAutoId()->SetValue(FromString<ui64>(Normalize()));
        }
        return proto;
    }

    TString TAutoId::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : ToString(proto.GetAutoId().GetValue());
    }
}
