#include "avito_hash.h"
#include "md5.h"

namespace NIdentifiers {
    bool TAvitoHash::Validate(const TString& value) {
        return RE2::FullMatch(value, MD5_REGEXP);
    }

    TString TAvitoHash::Next() {
        return TMd5::Next();
    }

    NCrypta::NIdentifiersProto::TGenericID TAvitoHash::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            auto proto_big_int = HexToUInt128(Normalize());
            proto.MutableAvitoHash()->MutableValue()->SetLo(proto_big_int.GetLo());
            proto.MutableAvitoHash()->MutableValue()->SetHi(proto_big_int.GetHi());
        }
        return proto;
   }

    TString TAvitoHash::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : UIntToHex(proto.GetAvitoHash().GetValue());
    }
}
