#include "avito_id.h"

#include <util/string/cast.h>

namespace NIdentifiers {
    bool TAvitoId::Validate(const TString& value) {
        return IsUint64(value);
    }

    TString TAvitoId::Next() {
        return NextNonZeroUInt();
    }

    NCrypta::NIdentifiersProto::TGenericID TAvitoId::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutableAvitoId()->SetValue(FromString<ui64>(Normalize()));
        }
        return proto;
    }

    TString TAvitoId::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : ToString(proto.GetAvitoId().GetValue());
    }
}
