#include "cryptaid.h"

#include <util/string/cast.h>

namespace NIdentifiers {
    bool TCryptaId::Validate(const TString& value) {
        return IsUint64(value);
    }

    TString TCryptaId::Next() {
        return NextNonZeroUInt();
    }

    NCrypta::NIdentifiersProto::TGenericID TCryptaId::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutableCryptaId()->SetValue(FromString<ui64>(Normalize()));
        }
        return proto;
    }

    TString TCryptaId::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto){
        return proto.HasRawValue() ? proto.GetRawValue() : ToString(proto.GetCryptaId().GetValue());
    }
}
