#include "direct_client_id.h"

#include <util/random/random.h>
#include <util/string/cast.h>

namespace NIdentifiers {
    bool TDirectClientId::Validate(const TString& value) {
        return (value != "0") && value.size() <= 10 && IsUint64(value);;
    }

    TString TDirectClientId::Next() {
        return ToString<ui64>(RandomNumber<ui64>(9999999998) + 1);;
    }

    NCrypta::NIdentifiersProto::TGenericID TDirectClientId::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutableDirectClientId()->SetValue(FromString<ui64>(Normalize()));
        }
        return proto;
    }

    TString TDirectClientId::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : ToString(proto.GetDirectClientId().GetValue());
    }
}
