#include "distrr1.h"

namespace NIdentifiers {
    bool TDistrR1::Validate(const TString& value) {
        return RE2::FullMatch(value, DISTR_R1_REGEXP);
    }

    TString TDistrR1::Next() {
        TString output;
        for (size_t index = 0; index < 132; ++index) {
            output.append(NextAlphaNumeric());
        }
        return output;
    }

    NCrypta::NIdentifiersProto::TGenericID TDistrR1::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutableDistrR1()->SetValue(Normalize());
        }
        return proto;
    }

    TString TDistrR1::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : proto.GetDistrR1().GetValue();
    }
}
