#include "distrui.h"
#include "mm_device_id.h"

#include <util/generic/string.h>

namespace NIdentifiers {
    bool TDistrUI::Validate(const TString& value) {
        return RE2::FullMatch(value, MM_DEVICE_ID_REGEXP);
    }

    TString TDistrUI::DoNormalize() const {
        TString normalized = Original;
        normalized.to_upper();
        if (normalized.size() == 32) {
            normalized = HexDigestDashes(normalized);
        }
        return normalized;
    }

    TString TDistrUI::Next() {
        TString output;
        while (output.size() < 32) {
            output.append(NextHexDigest());
        }
        return to_upper(HexDigestDashes(output));
    }

    NCrypta::NIdentifiersProto::TGenericID TDistrUI::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            auto proto_big_int = HexToUInt128(Normalize());
            proto.MutableDistrUI()->MutableValue()->SetLo(proto_big_int.GetLo());
            proto.MutableDistrUI()->MutableValue()->SetHi(proto_big_int.GetHi());
        }
        return proto;
    }

    TString TDistrUI::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : to_upper(HexDigestDashes(UIntToHex(proto.GetDistrUI().GetValue())));
    }

    bool TDistrUI::HasLikelihood() const {
        return true;
    }
}
